struct VSOutput {
	float4 PositionClipS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

static const float depth = 1;

VSOutput main(uint id : SV_VertexID) {
	VSOutput output = (VSOutput)0;
	switch(id) {
		case 0:
		case 3:
			// V0 - bottom left
			output.PositionClipS = float4(-1, -1, depth, 1);
			output.TexCoords = float2(0, 1);
			break;
		case 1:
			// V1 - top left
			output.PositionClipS = float4(-1,  1, depth, 1);
			output.TexCoords = float2(0, 0);
			break;
		case 2:
		case 4:
			// V2 - top right
			output.PositionClipS = float4( 1,  1, depth, 1);
			output.TexCoords = float2(1, 0);
			break;
		case 5:
		default:
			// V3 - bottom right
			output.PositionClipS = float4( 1, -1, depth, 1);
			output.TexCoords = float2(1, 1);
			break;
	}

	return output;
}